module.exports = function(grunt) {

	grunt.config('compass', {
		options: {
			sassDir: '<%= yeoman.app %>/_assets/css/sass',
			cssDir: '.tmp/_assets/css',
			imagesDir: '<%= yeoman.app %>/_assets/images',
			javascriptsDir: '<%= yeoman.app %>/libs',
			importPath: ['<%= yeoman.app %>/libs', '<%= yeoman.app %>/src', '<%= yeoman.app %>/_assets/css/sass'],
			relativeAssets: false,
			assetCacheBuster: false,
			noLineComments: true,
			debugInfo: false,
			raw: 'Sass::Script::Number.precision = 10\n'
		},
		server: {
			options: {
				debugInfo: false
			}
		}
	});

	grunt.loadNpmTasks('grunt-contrib-compass');

};
